#include "stdafx.h"
#include "R-KEMU-M3O-LF.h"
#include "R-KEMU-M3O-LFDlg.h"

#include "HookFunct.h"
#include "R-HH-M3O-LF-SDK.h"
#include "Utility.h"
#include "list"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define WM_TRAY_NOTIFY	WM_APP + 1000

CRKEMUM3OLFDlg::CRKEMUM3OLFDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRKEMUM3OLFDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bSilent = TRUE;
}

void CRKEMUM3OLFDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_KEY, m_ctrlKey);
	DDX_Control(pDX, IDC_CHECK_USE_TABS, m_ctrlUseTab);
	DDX_Control(pDX, IDC_CHECK_USE_RETURN, m_ctrlUseReturn);
	DDX_Control(pDX, IDC_BUTTON_START, m_ctrlStart);
	DDX_Control(pDX, IDC_BUTTON_STOP, m_ctrlStop);
	DDX_Control(pDX, IDC_EDIT_START_SECT, m_ctrlStartSect);
	DDX_Control(pDX, IDC_EDIT_NR_SECT, m_ctrlNrSect);
	DDX_Control(pDX, IDC_EDIT_DATA, m_ctrlData);
	DDX_Control(pDX, IDC_BUTTON_WRITE, m_btnWrite);
	DDX_Control(pDX, IDC_BUTTON_READ, m_btnRead);
	DDX_Control(pDX, IDC_EDIT_ERROR, m_ctrlError);
	DDX_Control(pDX, IDC_EDIT_LOGIN, m_ctrlLogin);
}

BEGIN_MESSAGE_MAP(CRKEMUM3OLFDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_TRAY_NOTIFY,		&CRKEMUM3OLFDlg::OnTrayNotify)
	ON_COMMAND(ID_MENU_SHOW, &CRKEMUM3OLFDlg::OnMenuShow)
	ON_WM_SYSCOMMAND()
	ON_WM_KEYDOWN()
	ON_WM_CHAR()
	ON_WM_SYSKEYDOWN()
	ON_WM_SYSCHAR()
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CRKEMUM3OLFDlg::OnBnClickedButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_START, &CRKEMUM3OLFDlg::OnBnClickedButtonStart)
	ON_COMMAND(ID_MENU_START, &CRKEMUM3OLFDlg::OnMenuStart)
	ON_COMMAND(ID_MENU_STOP, &CRKEMUM3OLFDlg::OnMenuStop)
	ON_WM_CLOSE()
	ON_WM_WINDOWPOSCHANGED()
	ON_BN_CLICKED(IDC_BUTTON_READ, &CRKEMUM3OLFDlg::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CRKEMUM3OLFDlg::OnBnClickedButtonWrite)
END_MESSAGE_MAP()


KEY_MAP tbKeyMap[] = 
{
	{_T("Default"),		0x5B},	//Left Windows key (Natural keyboard) 
	{_T("FN Key"),		0x0E},		
	{_T("Right Down"),	0x7D},	 
	{_T("Orange Key"),	0x7D},	
	{_T("Select Key"),	0x86},	
};

typedef struct _HOOK_INFO
{
	HHOOK__ *	hKeyHook;
	UINT		nSelKey;
	SDKHANDLE	hReader;
	BOOL		bUseEnter;
	BOOL		bUseTab;
}HOOK_INFO, *PHOOK_INFO;

HOOK_INFO	g_stHookInfo;


BOOL CRKEMUM3OLFDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_bStart = FALSE;
	EnableBtn();

	ZeroMemory(&g_stHookInfo, sizeof(HOOK_INFO));
	g_stHookInfo.nSelKey = 0x5B;

	for(UINT nCount = 0x00; nCount < sizeof(tbKeyMap) / sizeof(KEY_MAP); nCount++)
	{
		m_ctrlKey.SetItemData(m_ctrlKey.AddString(tbKeyMap[nCount].szKeyName), tbKeyMap[nCount].nKeyCode);
	}
	m_ctrlKey.SetCurSel(0x00);

	if(m_bSilent)
	{
		m_ctrlKey.SetCurSel(0x03);
		m_ctrlUseReturn.SetCheck(TRUE);
	}
	
	m_ctrlStartSect.SetWindowText(_T("0"));
	m_ctrlNrSect.SetWindowText(_T("1"));
	m_ctrlLogin.SetWindowText(_T("4D494B52"));
	return TRUE;  // return TRUE  unless you set the focus to a control
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CRKEMUM3OLFDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_RKEMUM3OUHF_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_RKEMUM3OUHF_DIALOG));
	}
}
#endif

LONG CRKEMUM3OLFDlg::OnTrayNotify (WPARAM wParam, LPARAM lParam)
{
	switch (lParam)
	{
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		{
			CMenu clsMenu;
			VERIFY(clsMenu.LoadMenu(IDR_MENU_TRAY_ICON));
			CMenu* pTrayMenu = clsMenu.GetSubMenu(0);

			POINT stMousePct ;
			GetCursorPos (&stMousePct) ;

			// Fix Microsofts' BUG!!!!
			SetForegroundWindow();
			if(pTrayMenu != NULL)
			{
				pTrayMenu->EnableMenuItem(ID_MENU_START, m_bStart ? MF_BYCOMMAND | MF_DISABLED | MF_GRAYED : MF_BYCOMMAND | MF_ENABLED);
				pTrayMenu->EnableMenuItem(ID_MENU_STOP, m_bStart ? MF_BYCOMMAND | MF_ENABLED : MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);

				pTrayMenu->TrackPopupMenu(TPM_LEFTALIGN /*| TPM_RIGHTBUTTON*/,
					stMousePct.x, stMousePct.y, AfxGetMainWnd());
			}
		}break;
	}

	return 0x00;
}

void CRKEMUM3OLFDlg::AddTrayIcon()
{
	m_stNotIcon.cbSize	= sizeof(NOTIFYICONDATA) ;
	m_stNotIcon.hWnd	= GetSafeHwnd() ;
	m_stNotIcon.uID		= 0 ;
	m_stNotIcon.uFlags	= NIF_MESSAGE | NIF_ICON | NIF_TIP ;	
	m_stNotIcon.hIcon	= m_hIcon ;
	m_stNotIcon.uCallbackMessage = WM_TRAY_NOTIFY;  
	_tcscpy_s( m_stNotIcon.szTip, 128, (TCHAR*)_T("IDTronic K.E."));
	Shell_NotifyIcon (NIM_ADD,&m_stNotIcon);
}

std::list<CHAR>	g_lsdId;
LRESULT CALLBACK KbdHook(int iCode, WPARAM wParam, LPARAM lParam)
{
	KBDLLHOOKSTRUCT* pstKbdInfo = (KBDLLHOOKSTRUCT*)lParam;
	if(pstKbdInfo != NULL)
	{
		if((wParam == HK_KEYDOWN) && (pstKbdInfo->vkCode == g_stHookInfo.nSelKey))
		{
			// get card and write it to text
			TRACE(_T("Button was press \n"));
			if(g_stHookInfo.hReader != NULL)
			{
				BYTE pData[MAX_PATH]; DWORD dwData = MAX_PATH; BYTE bRet = ER_OK;
				ZeroMemory(pData, MAX_PATH);
				// *(UINT*)pData = 0x00;
				if((bRet = GetReaderCaps(g_stHookInfo.hReader, ERD_SCAN_CARD, pData, dwData)) == ER_OK)
				{
					std::string strData = (char*)(pData + 0x01);// CUtility::DataToString(pData + 0x01, dwData - 0x01, FALSE);
					//strData += " ";
					//strData += CUtility::DataToString(pData + 0x04, 0x03, FALSE);
					if(g_stHookInfo.bUseTab)
					{
						strData += "\x09";
					}

					if(g_stHookInfo.bUseEnter)
					{
						strData += "\x0D";
					}

					USES_CONVERSION;
					TRACE(A2T(strData.c_str()));

					std::string::iterator it = strData.begin();
					while(it != strData.end())
					{
						keybd_event(*it, 0, 0, 0);
						keybd_event(*it, 0, KEYEVENTF_KEYUP, 0);
						it++;
					}
				}
			}
		}
	}

	return CallNextHookEx(g_stHookInfo.hKeyHook, iCode, wParam, lParam);
}

void CRKEMUM3OLFDlg::EnableBtn()
{
	m_ctrlStart.EnableWindow(!m_bStart);
	m_ctrlStop.EnableWindow(m_bStart);
	m_btnWrite.EnableWindow(!m_bStart);
	m_btnRead.EnableWindow(!m_bStart);
}

void CRKEMUM3OLFDlg::Start()
{
	// select key
	if(m_ctrlKey.GetCurSel() != LB_ERR)
	{
		g_stHookInfo.nSelKey = m_ctrlKey.GetItemData(m_ctrlKey.GetCurSel());
	}

	// set hook
	g_stHookInfo.hKeyHook	= SetWindowsHookEx(WH_KEYBOARD_LL, &KbdHook, GetModuleHandle(NULL), 0);
	if(g_stHookInfo.hReader != NULL)
	{
		CloseReader(g_stHookInfo.hReader);
		g_stHookInfo.hReader = NULL;
		Sleep(1000);
	}
	g_stHookInfo.hReader	= OpenReader();
	g_stHookInfo.bUseTab	= m_ctrlUseTab.GetCheck();
	g_stHookInfo.bUseEnter	= m_ctrlUseReturn.GetCheck();
	m_bStart				= TRUE;
}

void CRKEMUM3OLFDlg::Stop()
{
	UnhookWindowsHookEx(g_stHookInfo.hKeyHook);
	CloseReader(g_stHookInfo.hReader);
	g_stHookInfo.hReader	= NULL;
	m_bStart				= FALSE;
}

void CRKEMUM3OLFDlg::OnMenuShow()
{
	m_bSilent = FALSE;
	Shell_NotifyIcon(NIM_DELETE, &m_stNotIcon);
	ShowWindow(SW_SHOW);	
}

void CRKEMUM3OLFDlg::OnBnClickedButtonStop()
{
	Stop();
	EnableBtn();
}

void CRKEMUM3OLFDlg::OnBnClickedButtonStart()
{

	Start();
	EnableBtn();

	// minimize application
	AddTrayIcon();
	ShowWindow(SW_HIDE);
}


void CRKEMUM3OLFDlg::OnMenuStart()
{
	Start();
	EnableBtn();
}

void CRKEMUM3OLFDlg::OnMenuStop()
{
	Stop();
	EnableBtn();
}

void CRKEMUM3OLFDlg::OnClose()
{
	if(m_bStart)
	{
		Stop();
	}

	CDialog::OnClose();
}

void CRKEMUM3OLFDlg::OnWindowPosChanged(WINDOWPOS* lpwndpos)
{
	CDialog::OnWindowPosChanged(lpwndpos);

	 if ((lpwndpos->flags & SWP_SHOWWINDOW) && m_bSilent)
	 {
		// OnBnClickedButtonStart();
	 }
}

void CRKEMUM3OLFDlg::OnBnClickedButtonRead()
{
	EERROR eRet = ER_INVALID_POINTER;
	CString strError = _T("Error open reader !!!");
	SDKHANDLE hSdk = OpenReader();
	if(hSdk != NULL)
	{
		strError = _T("Error getting card !!!");
		BYTE* pData = new BYTE[MAX_PATH]; DWORD dwRet = MAX_PATH;
		if((eRet = GetReaderCaps(hSdk, ERD_SCAN_CARD, pData, dwRet)) == ER_OK)
		{
			// read data from card
			strError = _T("Invalid input data card !!!");
			CString strStartSect	= _T(""); 
			CString strNrSect		= _T(""); 
			m_ctrlStartSect.GetWindowText(strStartSect);
			m_ctrlNrSect.GetWindowText(strNrSect);
			eRet = ER_INVALID_DATA;
			USES_CONVERSION;
			if((strStartSect.GetLength() > 0x00) && (strNrSect.GetLength() > 0x00))
			{
				if(pData[0x00] == 'H')
				{
					CString strLogin = _T(""); 
					m_ctrlLogin.GetWindowText(strLogin);

					BYTE* pDataLogin = NULL; DWORD dwSize = 0x00;
					CUtility::HexToByte((BYTE*)T2A(strLogin), strLogin.GetLength(), &pDataLogin, dwSize);
					eRet = SetReaderCaps(hSdk, ERD_LOGIN, pDataLogin, dwSize);
				}

				DWORD dwNrSect = (DWORD)_ttoi((LPCTSTR)strNrSect);
				DWORD dwStartSect = (DWORD)_ttoi((LPCTSTR)strStartSect); dwRet = sizeof(UINT);					
				UINT nNav = 0x00;
				ZeroMemory(pData, MAX_PATH);
				eRet = ER_OK;
				while((eRet == ER_OK) && (dwNrSect > 0x00))
				{
					strError = _T("Invalid block number !!!");
					if((eRet = SetReaderCaps(hSdk, ERD_START_BLOCK, (BYTE*)&dwStartSect, dwRet)) == ER_OK)
					{
						// read 1 sector
						strError = _T("Error reading sector !!!");
						if((eRet = ReadData(hSdk, pData + nNav, dwRet)) == ER_OK)
						{
							strError = _T("Reading finish with no error !!!");
							dwStartSect++;
							dwNrSect--;
							nNav += dwRet;
						}
					}
				}

				m_ctrlData.SetWindowText(_T(""));
				if(eRet == ER_OK)
				{
					m_ctrlData.SetWindowText(A2T(CUtility::DataToString(pData, nNav, TRUE).c_str()));
				}
			}

			delete[] pData;
		}
		CloseReader(hSdk);
	}

	m_ctrlError.SetWindowText(strError);
}

#define SECT_SIZE	0x04
void CRKEMUM3OLFDlg::OnBnClickedButtonWrite()
{
	EERROR eRet = ER_INVALID_POINTER;
	CString strError = _T("Error open reader !!!");
	SDKHANDLE hSdk = OpenReader();
	if(hSdk != NULL)
	{
		strError = _T("Error getting card !!!");
		BYTE* pData = new BYTE[MAX_PATH]; DWORD dwRet = MAX_PATH;
		if((eRet = GetReaderCaps(hSdk, ERD_SCAN_CARD, pData, dwRet)) == ER_OK)
		{
			// check if we have hitag 1 card 
			USES_CONVERSION;
			if(pData[0x00] == 'H')
			{
				CString strLogin = _T(""); 
				m_ctrlLogin.GetWindowText(strLogin);

				BYTE* pDataLogin = NULL; DWORD dwSize = 0x00;
				CUtility::HexToByte((BYTE*)T2A(strLogin), strLogin.GetLength(), &pDataLogin, dwSize);
				eRet = SetReaderCaps(hSdk, ERD_LOGIN, pDataLogin, dwSize);
			}

			// read data from card
			strError = _T("Invalid input data card !!!");
			CString strStartSect	= _T(""); 
			CString strNrSect		= _T(""); 
			CString strData			= _T(""); 

			m_ctrlStartSect.GetWindowText(strStartSect);
			m_ctrlNrSect.GetWindowText(strNrSect);
			m_ctrlData.GetWindowText(strData);

			eRet = ER_INVALID_DATA;
			if((strStartSect.GetLength() > 0x00) && (strNrSect.GetLength() > 0x00) && (strData.GetLength() > 0x00))
			{
				DWORD dwNrSect = (DWORD)_ttoi((LPCTSTR)strNrSect);
				DWORD dwStartSect = (DWORD)_ttoi((LPCTSTR)strStartSect); dwRet = sizeof(UINT); 	
				strData.Remove('-');

				USES_CONVERSION;
				BYTE* pDataRet = NULL; DWORD dwLen = 0x00;
				CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strData), strData.GetLength(), &pDataRet, dwLen);

				UINT nNav = 0x00;
				ZeroMemory(pData, MAX_PATH);
				eRet = ER_OK;
				while((eRet == ER_OK) && (dwNrSect > 0x00))
				{
					strError = _T("Invalid block number !!!");
					if((eRet = SetReaderCaps(hSdk, ERD_START_BLOCK, (BYTE*)&dwStartSect, dwRet)) == ER_OK)
					{
						// read 1 sector
						strError = _T("Error writing sector !!!");
						if((eRet = WriteData(hSdk, pDataRet + nNav, SECT_SIZE)) == ER_OK)
						{
							strError = _T("Writing finish with no error !!!");
							dwStartSect++;
							dwNrSect--;
							nNav += SECT_SIZE;
						}
					}
				}
				delete[] pDataRet;
			}

			delete[] pData;
		}
		CloseReader(hSdk);
	}

	m_ctrlError.SetWindowText(strError);
}
